unit UnitGsm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, ShellAPI,
  Dialogs, AXmsCtrl_TLB, ComCtrls, ExtCtrls, StdCtrls, UnitSendOptions, UnitReceiveOptions,
  UnitPincode, UnitWap, UnitRingtone, UnitPicture, bsSkinData,
  BusinessSkinForm, bsSkinCtrls;

type
  TFormGsm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    ButtonPincode: TButton;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    EditRecipient: TEdit;
    ButtonWap: TButton;
    ButtonRingtone: TButton;
    ButtonPicture: TButton;
    ButtonSendOptions: TButton;
    Panel1: TPanel;
    GroupBox3: TGroupBox;
    ListView1: TListView;
    ButtonReceiveOptions: TButton;
    GroupBox4: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    EditLogfile: TEdit;
    ButtonView: TButton;
    EditMessage: TMemo;
    Timer1: TTimer;
    sf1: TbsBusinessSkinForm;
    bsSkinData1: TbsSkinData;
    bsCompressedStoredSkin1: TbsCompressedStoredSkin;
    bsSkinButton1: TbsSkinButton;
    ButtonReceive: TbsSkinButton;
    
    procedure FormCreate(Sender: TObject);
    procedure ButtonSendClick(Sender: TObject);
    procedure ButtonViewClick(Sender: TObject);
    procedure ButtonSendOptionsClick(Sender: TObject);
    procedure ButtonReceiveOptionsClick(Sender: TObject);
    procedure ButtonReceiveClick(Sender: TObject);
    procedure ButtonPincodeClick(Sender: TObject);
    procedure ButtonWapClick(Sender: TObject);
    procedure ButtonRingtoneClick(Sender: TObject);
    procedure ButtonPictureClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);

  private
    objGsm        : ISmsProtocolGsm;
    objMessage    : ISmsMessage;
    objConstants  : ISmsConstants;

    bUnicode      : Boolean;
    bMultipart    : Boolean;
    bFlash        : Boolean;
    bUDH          : Boolean;
    bDelete       : Boolean;

    nStorage      : Integer;
    
    function GetTempDirectory ()  : String;
    function GetResult ()  : Integer;
  public
    { Public declarations }
  end;

var
  FormGsm: TFormGsm;

implementation

uses Unit1;

{$R *.dfm}

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.FormCreate(Sender: TObject);
var NumDevices    : Integer;
var i             : Integer;
begin
  objGsm        := TSmsProtocolGsm.Create(Application).DefaultInterface;
  objMessage    := TSmsMessage.Create(Application).DefaultInterface;
  objConstants  := TSmsConstants.Create(Application).DefaultInterface;

  mainform.ComboDevices.Items.Add ( 'COM1' );
  mainform.ComboDevices.Items.Add ( 'COM2' );
  mainform.ComboDevices.Items.Add ( 'COM3' );
  mainform.ComboDevices.Items.Add ( 'COM4' );
  mainform.ComboDevices.Items.Add ( 'COM5' );
  mainform.ComboDevices.Items.Add ( 'COM6' );
  mainform.ComboDevices.Items.Add ( 'COM7' );
  mainform.ComboDevices.Items.Add ( 'COM8' );
  mainform.ComboDevices.Items.Add ( 'COM9' );
  mainform.ComboDevices.Items.Add ( 'COM10' );
  mainform.ComboDevices.Items.Add ( 'COM11' );
  mainform.ComboDevices.Items.Add ( 'COM12' );
  mainform.ComboDevices.Items.Add ( 'COM13' );
  mainform.ComboDevices.Items.Add ( 'COM14' );
  mainform.ComboDevices.Items.Add ( 'COM15' );
  mainform.ComboDevices.Items.Add ( 'COM16' );

  NumDevices := objGsm.GetDeviceCount ();

  for i:=0 to NumDevices do begin
    mainform.ComboDevices.Items.Add ( objGsm.GetDevice( i ) );
  end;

  mainform.ComboDevices.ItemIndex := 0;

  GetTempDirectory ();
end;

{////////////////////////////////////////////////////////////////////////////////}

function TFormGsm.GetTempDirectory () : String;
var Buffer : array [0..MAX_PATH] of Char;
begin
  GetTempPath ( MAX_PATH, Buffer );
  EditLogfile.Text := StrPas ( Buffer ) + 'GsmLog.txt';
end;

{////////////////////////////////////////////////////////////////////////////////}

function TFormGsm.GetResult () : Integer;
begin
  Result := objGsm.LastError;

  mainform.status.Items.Add(IntToStr ( Result ) + ' : ' + objGsm.GetErrorDescription( Result ));
  mainform.status.ItemIndex:=mainform.status.Items.Count-1;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonSendClick(Sender: TObject);
var vtVar : OleVariant;
begin
  objGsm.Device  := mainform.ComboDevices.Text;
  objGsm.LogFile          := EditLogfile.Text;

  objMessage.Recipient    := EditRecipient.Text;
  objMessage.Data         := EditMessage.Text;

  objMessage.Format := objConstants.asMESSAGEFORMAT_TEXT_MULTIPART;

  {
  if ( bUnicode = true ) then begin
    if ( bMultipart = true ) then begin
      objMessage.Format := objConstants.asMESSAGEFORMAT_UNICODE_MULTIPART;
    end
    else
    begin
      objMessage.Format := objConstants.asMESSAGEFORMAT_UNICODE;
    end;
    if ( bFlash = true ) then begin
      objMessage.Format := objConstants.asMESSAGEFORMAT_UNICODE_FLASH;
    end;
  end
  else
  begin
    if ( bMultipart = true ) then
    begin
      objMessage.Format := objConstants.asMESSAGEFORMAT_TEXT_MULTIPART;
    end
    else
    begin
      objMessage.Format := objConstants.asMESSAGEFORMAT_TEXT;
    end;
    if ( bFlash = true ) then
    begin
      objMessage.Format := objConstants.asMESSAGEFORMAT_TEXT_FLASH;
    end;
  end;
  }

  vtVar := objMessage;

  timer1.Enabled:=false;
  Screen.Cursor := crHourGlass;
  objGsm.Send  ( vtVar );
  Screen.Cursor := crDefault;
  timer1.Enabled:=true;
  EditMessage.Lines.Clear;
  EditRecipient.Text:='';
  GetResult ();
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonSendOptionsClick(Sender: TObject);
begin
  FormSendOptions.CheckMultipart.Checked  := bMultipart;
  FormSendOptions.CheckFlash.Checked      := bFlash;
  FormSendOptions.CheckUnicode.Checked    := bUnicode;
  FormSendOptions.CheckUDH.Checked        := bUDH;

  if FormSendOptions.ShowModal = mrOK then begin
    bMultipart  := FormSendOptions.CheckMultipart.Checked;
    bFlash      := FormSendOptions.CheckFlash.Checked;
    bUDH        := FormSendOptions.CheckUDH.Checked;
    bUnicode    := FormSendOptions.CheckUnicode.Checked;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonReceiveOptionsClick(Sender: TObject);
begin
  FormReceiveOptions.CheckDelete.Checked    := bDelete;
  FormReceiveOptions.ComboStorage.ItemIndex := nStorage;

  if FormReceiveOptions.ShowModal = mrOK then begin
    bDelete   := FormReceiveOptions.CheckDelete.Checked;
    nStorage  := FormReceiveOptions.ComboStorage.ItemIndex;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonPincodeClick(Sender: TObject);
var PinCode : String;
begin
  if FormPinCode.ShowModal = mrOK then begin
    objGsm.Device            := mainform.ComboDevices.Text;
    objGsm.LogFile           := EditLogFile.Text;

    Screen.Cursor := crHourGlass;
    objGsm.EnterPin(PinCode);
    Screen.Cursor := crDefault;

    GetResult ();
  end;
end;
{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonReceiveClick(Sender: TObject);
var Item  : TListItem;
var Msg   : ISmsMessage;
var vtVar : OleVariant;
    name:string;
begin
  objGsm.Device             := mainform.ComboDevices.Text;
  objGsm.LogFile            := EditLogfile.Text;
  mainform.info.Caption:=objgsm.Build;
  mainform.info2.Caption:=objgsm.Version;
  
  ListView1.Items.Clear;

  objGsm.DeleteAfterReceive :=1;// Integer ( bDelete );

  objGsm.MessageStorage     := nStorage;
  Screen.Cursor := crHourGlass;
  objGsm.Receive;
  Screen.Cursor := crDefault;

  if ( GetResult () = 0 ) then
  begin
    vtVar := objGsm.GetFirstMessage;
    if (GetResult=0) then
    repeat
        Msg := IDispatch ( vtVar ) as ISmsMessage;
        Item := ListView1.Items.Add;

        Item.Caption  := Msg.Sender;

        Item.SubItems.Add(Msg.Time);
        Item.SubItems.Add(Msg.Data);
        //editmessage.Text:=Msg.Data;

        mainform.memo2.Lines.Clear;
        mainform.memo2.Lines.Add('#SMS#');
        mainform.memo2.Lines.Add(Msg.Sender);
        mainform.memo2.Lines.Add(datetostr(strtodatetime(Msg.Time))+' '+TimeToStr(strtodatetime(Msg.Time)));
        mainform.memo2.Lines.Add(Msg.Data);
        mainform.sending(mainform.memo2.Lines.Text);
        vtVar := objGsm.GetNextMessage;

    until getresult<>0;
  end;

  objGsm.MessageStorage     :=1;
  Screen.Cursor := crHourGlass;
  objGsm.Receive;
  Screen.Cursor := crDefault;

  if ( GetResult () = 0 ) then
  begin
    vtVar := objGsm.GetFirstMessage;
    if (GetResult=0) then
    repeat
        Msg := IDispatch ( vtVar ) as ISmsMessage;
        Item := ListView1.Items.Add;

        Item.Caption  := Msg.Sender;

        Item.SubItems.Add(Msg.Time);
        Item.SubItems.Add(Msg.Data);

        mainform.memo2.Lines.Clear;
        mainform.memo2.Lines.Add('#SMS#');
        mainform.memo2.Lines.Add(Msg.Sender);
        mainform.memo2.Lines.Add(datetostr(strtodatetime(Msg.Time))+' '+TimeToStr(strtodatetime(Msg.Time)));
        mainform.memo2.Lines.Add(Msg.Data);
        mainform.sending(mainform.memo2.Lines.Text);
        vtVar := objGsm.GetNextMessage;
    until getresult<>0;
  end;

end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonViewClick(Sender: TObject);
var LogFile : PAnsiChar;
begin
  LogFile := StrNew(PChar(editLogFile.Text));

  ShellExecute ( 0, 'open' , LogFile, '', '', SW_SHOW );
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonWapClick(Sender: TObject);
begin
  if ( FormWap.ShowModal = mrOK ) then begin
    EditMessage.Text := FormWap.strMessage;

    bMultipart      := false;
    bUnicode        := false;
    bFlash          := false;
    bUDH            := true;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonRingtoneClick(Sender: TObject);
begin
  if ( FormRingtone.ShowModal = mrOK ) then begin
    EditMessage.Text := FormRingtone.strMessage;

    bMultipart      := false;
    bUnicode        := false;
    bFlash          := false;
    bUDH            := true;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.ButtonPictureClick(Sender: TObject);
begin
  if ( FormPicture.ShowModal = mrOK ) then begin
    EditMessage.Text := FormPicture.strMessage;

    bMultipart      := false;
    bUnicode        := false;
    bFlash          := false;
    bUDH            := true;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormGsm.Timer1Timer(Sender: TObject);
begin
  ButtonReceive.OnClick(self);
end;

end.




